#include<bits/stdc++.h>
using namespace std;

typedef long long ll;

const int MAXN = 1e6;
int n;
ll h[MAXN];

vector<ll> hull (int l, int r){
    vector<ll> st;

    for (int i = l; i <= r; i++) {
        while (st.size() >= 2) {
            ll u = st[st.size() - 2];
            ll v = st[st.size() - 1];

            ll lhs = (h[v] - h[u]) * (i - v);
            ll rhs = (h[i] - h[v]) * (v - u);

            if (lhs <= rhs) st.pop_back();
            else break;
        }
        st.push_back(i);
    }
    return st;

}

int main(){
    cin >>n;
    int lh=-1, rh=-1;
    for (int i = 0; i < n; ++i){
        cin >>h[i];
        if (h[i]>h[0] && lh == -1){
            lh = i;
        }
    }
    if (h[0] < h[1] || h[n-2] > h[n-1]){
        cout <<-1 <<"\n";
        return 0;
    }

    for (int i = 0; i < n; ++i){
        if (h[i] > h[n-1]){
            rh = i;
        }
    }

    int l = 0, r = n-1;
    if (lh != -1){
        l = lh-1;
        for (int i = lh-1; i > 0; --i){
            ll lhs = (h[l] - h[i]) * (lh - l);
            ll rhs = (h[lh] - h[l]) * (l - i);

            if (lhs <= rhs)l = i;
        }
    }
    if (rh != -1){
        r = rh+1;
        for (int i = rh-1; i < n-1; ++i){
            ll lhs = (h[r] - h[rh]) * (i - r);
            ll rhs = (h[i] - h[r]) * (r - rh);

            if (lhs <= rhs)r = i;
        }
    }
    if (lh == -1 && rh == -1){
        if (h[0] == h[n-1])cout <<1 <<"\n";
        else cout <<2 <<"\n";
        return 0;
    }

    vector<ll> hl = hull(l, r);
    if (lh != -1) hl.insert (hl.begin(), 0);
    if (rh != -1) hl.push_back (n-1);

    cout <<hl.size()-1 <<"\n";

    return 0;
}
